<?php
namespace bings;

include_once dirname(__DIR__).'/config.php';

/**
 * Web search query
 *
 * Azure Bing Version: (state: 2016-06-21)
  *
 * @author Rokkada
 * @copyright &copy; 2016 Rokkada
 * @package bings
 * @version 1.0
 */
class doc_query implements \JsonSerializable, query {

    const FILTER_FORMAT_JSON = '$format=json';

    const FILTER_WEB_FILETYPE = 'WebFileType=%27PDF%27';  // DOC, PDF, TEXT, TXT, PPT, RTF, XLS, FEED, HTM, HTML (based on testing it does not seem to allow combining file types with + seperator (%2b)

    const FILTER_ADULT = 'Adult=%27Strict%27';  // Strict, Modelate, Off

    const FILTER_MARKET = "Market=%27en-US%27";

    //const BASE_URL = 'https://api.datamarket.azure.com/Data.ashx/Bing/Search/';
    //const BASE_URL = 'https://api.cognitive.microsoft.com/bing/v5.0/search';
    const BASE_URL = 'https://api.cognitive.microsoft.com/bing/v7.0/search'; //Jan 1st 2019

    //const BASE_URL = 'http://localhost/bing5service/web_service.php';

    const SOURCE_TYPE = 'Web';

    const FILTER_TOP = '$top=20';

    const FILTER_SKIP = '$skip=0';

    // bing v5
    const FILTER_QUERY_V5 = 'q';
    const FILTER_FTYPE_V5 = 'filetype:pdf';
    const FILTER_MKT_V5 = 'mkt=en-US';
    const FILTER_RESF_V5 = 'responseFilter=webpages';
    const FILTER_COUNT_V5 = 'count=30';
    const FILTER_SAFESER_V5 = 'safeSearch=strict';

    /**
     * @var string search term
     */
    protected $keyword = null;

    /**
     * @var int Total number of results to return. Maximum value is 50. Default sets count to 50.
     */
    protected $top = 50; // max number

    /**
     * @var int Ordinal position of first result. First position is 0. Default sets start to 0.
     */
    protected $skip = 0; // start at

    protected $search_url;

    /**
     * @param keyword $keyword search term or query string like /ysearch/web/v1/foo?params
     */
    public function __construct(keyword $keyword)
    {
        $this->set_keyword($keyword);
        $this->set_search_url();
    }

    /**
     * Sets search query
     *
     * @param string $keyword
     */
    public function set_keyword($keyword)
    {
        $this->keyword = $keyword;
        return $this;
    }

    /**
     * @return string Search term
     */
    public function get_keyword() {
        return $this->keyword;
    }

    /**
     * @return int Ordinal position of first result. First position is 0.
     */
    public function get_top() {
        return (int)$this->top;
    }

    /**
     * @return int Total number of results to return.
     */
    public function get_skip() {
        return $this->skip;
    }

    private function set_search_url() {

        // old bing
        //$this->search_url = doc_query::BASE_URL . doc_query::SOURCE_TYPE . '?Query=%27'. urlencode($this->get_keyword()->get_search_text()) . '%27&' . doc_query::FILTER_FORMAT_JSON . '&' . doc_query::FILTER_MARKET . '&' . doc_query::FILTER_ADULT . '&' . doc_query::FILTER_WEB_FILETYPE . '&' . doc_query::FILTER_TOP . '&' . doc_query::FILTER_SKIP;

        ////debug_to_console('server - search url: '.$this->search_url);
        //$surl = 'https://api.datamarket.azure.com/Data.ashx/Bing/Search/Web?Query=%27'.urlencode($this->getQuery()).'%27&$format=json&Market=%27en-US%27&Adult=%27Strict%27&WebFileType=%27PDF%27';
        //console.print_r($surl);

        // bing 5
        //https://api.cognitive.microsoft.com/bing/v5.0/search?q=reflexive+pronouns+test+papers+for+class-5+worksheets+filetype:pdf&mkt=en-us&responseFilter=webpages&count=50&mkt=en-US&safeSearch=strict
        $this->search_url = doc_query::BASE_URL . '?' . doc_query::FILTER_QUERY_V5 . '=' .  urlencode($this->get_keyword()->get_search_text()) . '+' . doc_query::FILTER_FTYPE_V5 . '&' . doc_query::FILTER_MKT_V5 . '&' . doc_query::FILTER_SAFESER_V5 . '&' . doc_query::FILTER_RESF_V5 . '&' . doc_query::FILTER_COUNT_V5;
        debug_to_console('server - search url: '.$this->search_url);
    }

    public function get_search_url() {
        return $this->search_url;
        //return $surl;
    }

    public function jsonSerialize() {
        return [
            'keyword' => $this->get_keyword(),
            'search_url' => $this->get_search_url()
        ];
    }
}