<?php
namespace bings;
/**
 * Abstract class for single seach results
 *
 * @author Rokkada
 * @copyright &copy; 2016 Rokkada
 * @package bings
 * @version 1.0
 *
 */
class doc_result implements \JsonSerializable {

    protected $ID;
    protected $Title;
    protected $Description;
    protected $Url;
    protected $DisplayUrl;
    protected $__metadata;

    /**
     * @access package
     * @param array $responseArray Array of results from JSON response
     */
    public function __construct(array $responseArray = array())
    {
        foreach($responseArray as $key=>$value) {
            $this->$key = $value;
        }
    }
    /**
     * Getter for read-only properties
     *
     * @param string $var
     * @return string
     */
    public function __get($var)
    {
        return $this->$var;
    }


    public function jsonSerialize() {
        return [
            //'id' => $this->ID,
            'title' => $this->Title,
            'cleantitle' => util::cleaner($this->Title),
            //'description' => $this->Description,
            'url' => $this->Url,
            //'dispurl' => $this->DisplayUrl,
            //'__meta' => $this->__metadata
        ];
    }
}