<?php
namespace bings;
/**
 * Abstract class for single search result
 *
 * @author Rokkada
 * @copyright &copy; 2016 Rokkada
 * @package bings
 * @version 1.0
 *
 *
 *
ID
Title
MediaUrl
SourceUrl
DisplayUrl
Width
Height
FileSize
ContentType
Thumpnail
    MediaUrl
    http://ts3.mm.bing.net/th?id=OIP.Meb233bcbddb04bd2d570f65e118eef41H0&pid=15.1
    ContentType
    image/jpg
    Width
    258
    Height
    300
    FileSize
    16241
 *
 */
class img_result implements \JsonSerializable {

    protected $ID;
    protected $Title;
    protected $MediaUrl;
    protected $SourceUrl;
    protected $DisplayUrl;
    protected $Width;
    protected $Height;
    protected $FileSize;
    protected $ContentType;
    protected $Thumbnail;

    /**
     * @access package
     * @param array $responseArray Array of results from JSON response
     */
    public function __construct(array $responseArray = array())
    {
        foreach($responseArray as $key=>$value) {
            $this->$key = $value;
        }
    }
    /**
     * Getter for read-only properties
     *
     * @param string $var
     * @return string
     */
    public function __get($var)
    {
        return $this->$var;
    }

    public function jsonSerialize() {
        return [ // some of the attributes are commented to make the response lighter
            'id' => $this->ID,
            'title' => $this->Title,
            'cleantitle' => $this->Title,
            'mediaurl' => $this->MediaUrl,
            //'sourceurl' => $this->SourceUrl,
            //'displayurl' => $this->DisplayUrl,
            //'width' => $this->Width,
            //'height' => $this->Height,
            //'filesize' => $this->FileSize,
            //'content_type' => $this->ContentType,
            'thumbnail_mediaurl' => $this->Thumbnail['MediaUrl'],
            'thumbnail_height' => $this->Thumbnail['Height'],
            'thumbnail_width' => $this->Thumbnail['Width']
            ];
    }
}