<?php
/**
 * Created by PhpStorm.
 * User: Man
 * Date: 25-06-2016
 * Time: 01:27 PM
 */

namespace bings;

include_once dirname(__DIR__).'/config.php';
include_once dirname(__DIR__).'/word_checker.php';

class keyword implements \JsonSerializable {

    protected $type = null;

    protected $raw_text = null;

    protected $clean_text = null;

    protected $search_suffix = null;

    protected $search_text = null;

    protected $slug = null;

    protected $cache_name = null;

    protected $is_valid = true;

    protected $title_text = null;

    protected $error = null;


    public function get_type() {
        return $this->type;
    }

    public function get_raw_text() {
        return $this->raw_text;
    }

    public function get_clean_text() {
        return $this->clean_text;
    }

    public function get_search_text() {
        return $this->search_text;
    }

    public function get_search_suffix() {
        return $this->search_text;
    }

    public function get_title_text() {
        return $this->title_text;
    }

    public function get_slug() {
        return $this->cache_name;
    }

    public function get_cache_name() {
        return $this->cache_name;
    }

    public function is_valid() {
        return $this->is_valid;
    }

    public function get_error() {
        return $this->error;
    }


    public function __construct($query, $stype)
    {
        $this->raw_text = urldecode($query);
        $this->type = $stype;

        if (!isset($this->raw_text)) {
            $this->is_valid = false;
            return;
        }

        if ($this->type === 'ws') {
            $this->search_suffix = 'worksheets';
        }
        else if($this->type === 'cp') {
            $this->search_suffix = 'coloring pages';
        }
        // check if it contains adult/abusive words
        $this->cleanup(strtolower($this->raw_text));
        //$this->is_valid = true;
        return $this;
    }

    private function cleanup($input) {
        // remove special chars
        global $CFG;
        //replace dash with space (imp: before regex cleanup)
        $input = str_replace("-", " ", $input);

        $kw_clean_find = '';
        $kw_clean_replace = '';

        // if type is worksheet
        if($this->type === 'ws') {
            $kw_clean_find = $CFG->ws_kw_clean_find;
            $kw_clean_replace = $CFG->ws_kw_clean_replace;
        }
        elseif ($this->type === 'cp') { // else if type is coloring pages
            $kw_clean_find = $CFG->cp_kw_clean_find;
            $kw_clean_replace = $CFG->cp_kw_clean_replace;
        }
        $input = str_replace($kw_clean_find, $kw_clean_replace, $input);

        $find_reg = array('/[^a-z0-9 ]+/i', '/ +/');
        $replace_reg = array('', ' ');

        $input = preg_replace($find_reg, $replace_reg, $input);

        // convert to all lower
        $this->clean_text = trim(strtolower($input));


        // check if this word is corrupt or bad (adult)
        if($this->is_corrupt($this->raw_text) || is_bad($this->raw_text) || is_bad($this->clean_text)) {
            $this->is_valid = false;
            $this->error = "bad input";
            //return;
        }

        // convert to init upper
        $this->title_text = ucwords($this->clean_text);

        // search keyword (all lower with suffix)
        $this->search_text = $this->clean_text.' '.$this->search_suffix;

        // cache name
        $this->slug = str_replace(" ","-",$this->clean_text);

        // cache name
        $this->cache_name = str_replace(" ","_",$this->clean_text);
    }

    private function is_corrupt($keyword) {

        // if word is alphanumeric & does not contain space & length is more than 20, it must be junk
        if(ctype_alnum($keyword) && strlen($keyword) > 22) {
            //echo 'string is corrupt 1<br>';
            return true;
        }
        // the keyword does not have space & contains alphabets & also contains 20, means corruption in url encode
        if (!preg_match('/\s/', $keyword) && preg_match('/^[a-zA-Z0-9]+$/', $keyword) && strpos($keyword, '20')) {
            //echo 'string is encoding corrupt<br>';
            return true;
        }
        else {
            //echo 'string is NOT corrupt<br>';
            return false;
        }
    }

    public function jsonSerialize() {
        return [
            'type' => $this->type,
            'raw_text' => $this->raw_text,
            'clean_text' => $this->clean_text,
            'search_suffix' => $this->search_suffix,
            'search_text' => $this->search_text,
            'title_text' => $this->title_text,
            'slug' => $this->slug,
            'cache_name' => $this->cache_name,
            'is_valid' => $this->is_valid,
            'error' => $this->error
        ];
    }

}