<?php
namespace bings;

include_once dirname(__DIR__).'/config.php';

/**
 * Result set returned by search query
 *
 * @author
 * @copyright &copy; 2010 SGH informationstechnologie UG
 * @license BSD
 * @link http://creativecommons.org/licenses/BSD/
 * @package BASC
 * @version 1.0
 */
class result_set implements \IteratorAggregate, \JsonSerializable
{
    /**
     * @var bings\doc_query
     */
    private $query;
    /**
     * @var bings\doc_result[]
     */
    private $results = array();

    private $source; // 1st jan 2019 - to identify the search source from which result was returned

    /**
     *
     * @access package
     * @param array $responseArray Array from JSON response
     * @param Query $query Corresponding Query object
     * @param \DateTime $time Time when the Result was fetched from BOSS API
     */
    public function __construct(query $query, $json_response, $source) {

        $this->set_query($query);
        $this->set_source($source);

        if(!isset($json_response)) {// if null (happens when both cache is disabled or does not exist & api call is also disabled
            debug_to_console('server - FATAL: NO DATA TO CREATE RESULT SET');
            return;
        }

        if ($query->get_keyword()->get_type() === 'ws') {


            // added 1 jan 2019 - bing7
            if ($source === 'bing7') {

                debug_to_console('server - creating bing7 resultset');

                foreach ($json_response['webPages']['value'] as $bing_result) {

                    debug_to_console('server - bing7 worksheet url ' . $bing_result['url']);

                    $result = array("Title" => $bing_result['name'], "Description" => $bing_result['snippet'], "Url" => $bing_result['url'], "DisplayUrl" => $bing_result['displayUrl'], "__metadata" => null);

                    // ignore the result if it is in exclusion list
                    if ($this->is_ws_clean($result['Url'])) {
                        $this->results[] = new doc_result($result);
                    } else {
                        debug_to_console('server - url is not clean: ' . $result['Url']);
                    }
                }
            }
            else if ($source === 'bing5') {

                debug_to_console('server - creating bing5 resultset');

                foreach ($json_response['webPages']['value'] as $bing_result) {

                    // worksheet url in b5 is not straight-forward. We need to extract from the url value in the result
                    ////url=https://www.bing.com/cr?IG=04EE3937517747AFA9AFD9D1FFEA49F1&CID=125BDFBE33276C8A2105D5FF32356DC0&rd=1&h=FAX2C93gUbC9YVzX3-w6QE1Uldkw7TOxiWgsqDHVzfg&v=1&r=https%3a%2f%2fwww.allkidsnetwork.com%2fmath%2faddition%2fworksheets%2fmath-worksheet-addition-1.pdf&p=DevEx,5049.1

                    $parts = parse_url($bing_result['url']);
                    parse_str($parts['query'], $query);

                    debug_to_console('server - bing5 worksheet url ' . $query['r']);

                    $result = array("Title" => $bing_result['name'], "Description" => $bing_result['snippet'], "Url" => $query['r'], "DisplayUrl" => $bing_result['displayUrl'], "__metadata" => null);

                    // ignore the result if it is in exclusion list
                    if ($this->is_ws_clean($result['Url'])) {
                        $this->results[] = new doc_result($result);
                    } else {
                        debug_to_console('server - url is not clean: ' . $result['Url']);
                    }
                }
            }
            else if ($source === 'bing') {

                debug_to_console('server - creating bing resultset');

                foreach ($json_response['d']['results'] as $bing_result) {
                    // ignore the result if it is in exclusion list
                    if ($this->is_ws_clean($bing_result['Url'])) {
                        $this->results[] = new doc_result($bing_result);
                    } else {
                        debug_to_console('server - url is not clean: ' . $bing_result['Url']);
                    }
                }

            } else if ($source === 'boss') {

                debug_to_console('server - creating boss resultset');

                foreach ($json_response['bossresponse']['limitedweb']['results'] as $boss_result) {

                    $result = array("Title" => $boss_result['title'], "Description" => $boss_result['abstract'], "Url" => $boss_result['url'], "DisplayUrl" => $boss_result['dispurl'], "__metadata" => null);

                    // ignore the result if it is in exclusion list
                    if ($this->is_ws_clean($result['Url'])) {
                        $this->results[] = new doc_result($result);
                    } else {
                        debug_to_console('server - url is not clean: ' . $result['Url']);
                    }

                }
            }
        } else if ($query->get_keyword()->get_type() === 'cp') {

            // bing7 - 1st jan 2019
            if ($source === 'bing7') {

                debug_to_console('server - creating bing7 resultset');

                foreach ($json_response['images']['value'] as $bing_result) {

                    // worksheet url in b5 is not straight-forward. We need to extract from the url value in the result
                    ////url=https://www.bing.com/cr?IG=04EE3937517747AFA9AFD9D1FFEA49F1&CID=125BDFBE33276C8A2105D5FF32356DC0&rd=1&h=FAX2C93gUbC9YVzX3-w6QE1Uldkw7TOxiWgsqDHVzfg&v=1&r=https%3a%2f%2fwww.allkidsnetwork.com%2fmath%2faddition%2fworksheets%2fmath-worksheet-addition-1.pdf&p=DevEx,5049.1

                    //$parts = parse_url($result['hostPageUrl']);
                    //parse_str($parts['query'], $query);

                    debug_to_console('server - bing7 coloring page url ' . $bing_result['contentUrl']);

                    $result = array("ID" => '', "Title" => $bing_result['name'], "MediaUrl" => $bing_result['contentUrl'], "SourceUrl" => $bing_result['hostPageUrl'], "DisplayUrl" => $bing_result['contentUrl'],
                        "Height" => $bing_result['height'], "Width" => $bing_result['width'], "FileSize" => $bing_result['contentSize'],
                        "Thumbnail" => array("MediaUrl" => $bing_result['thumbnailUrl'], "Height" => $bing_result['thumbnail']['height'], "Width" => $bing_result['thumbnail']['width']));

                    // ignore the result if it is in exclusion list
                    if ($this->is_cp_clean($result['MediaUrl'])) {
                        $this->results[] = new img_result($result);

                    } else {
                        debug_to_console('server - url is not clean: ' . $result['MediaUrl']);
                    }
                }
            }
            else if ($source === 'bing5') {

                debug_to_console('server - creating bing5 resultset');

                foreach ($json_response['images']['value'] as $bing_result) {

                    // worksheet url in b5 is not straight-forward. We need to extract from the url value in the result
                    ////url=https://www.bing.com/cr?IG=04EE3937517747AFA9AFD9D1FFEA49F1&CID=125BDFBE33276C8A2105D5FF32356DC0&rd=1&h=FAX2C93gUbC9YVzX3-w6QE1Uldkw7TOxiWgsqDHVzfg&v=1&r=https%3a%2f%2fwww.allkidsnetwork.com%2fmath%2faddition%2fworksheets%2fmath-worksheet-addition-1.pdf&p=DevEx,5049.1

                    $parts = parse_url($bing_result['hostPageUrl']);
                    parse_str($parts['query'], $query);

                    debug_to_console('server - bing5 coloring page url ' . $bing_result['contentUrl']);

                    $result = array("ID" => '', "Title" => $bing_result['name'], "MediaUrl" => $bing_result['contentUrl'], "SourceUrl" => $query['r'], "DisplayUrl" => $bing_result['contentUrl'],
                        "Height" => $bing_result['height'], "Width" => $bing_result['width'], "FileSize" => $bing_result['contentSize'],
                        "Thumbnail" => array("MediaUrl" => $bing_result['thumbnailUrl'], "Height" => $bing_result['thumbnail']['height'], "Width" => $bing_result['thumbnail']['width']));

                    // ignore the result if it is in exclusion list
                    if ($this->is_cp_clean($result['MediaUrl'])) {
                        $this->results[] = new img_result($result);

                    } else {
                        debug_to_console('server - url is not clean: ' . $result['MediaUrl']);
                    }
                }
            }
            else if ($source === 'bing') {

                debug_to_console('server - creating bing resultset');

                foreach ($json_response['d']['results'] as $bing_result) {
                    // ignore the result if it is in exclusion list
                    if ($this->is_cp_clean($bing_result['MediaUrl'])) {
                        $this->results[] = new img_result($bing_result);

                    } else {
                        debug_to_console('server - url is not clean: ' . $bing_result['MediaUrl']);
                    }
                }

            } else if ($source === 'boss') { // *** NEEDS WORK

                debug_to_console('server - creating boss resultset');

                foreach ($json_response['bossresponse']['images']['results'] as $boss_result) {

                    $result = array("ID" => '', "Title" => $boss_result['title'], "MediaUrl" => $boss_result['url'], "SourceUrl" => $boss_result['clickurl'], "DisplayUrl" => $boss_result['refererclickurl'],
                        "Height" => $boss_result['height'], "Width" => $boss_result['width'], "FileSize" => $boss_result['size'],
                        "Thumbnail" => array("MediaUrl" => $boss_result['thumbnailurl'], "Height" => $boss_result['thumbnailheight'], "Width" => $boss_result['thumbnailwidth']));

                    // ignore the result if it is in exclusion list
                    if ($this->is_cp_clean($result['MediaUrl'])) {
                        $this->results[] = new img_result($result);
                    } else {
                        debug_to_console('server - url is not clean: ' . $result['MediaUrl']);
                    }

                } //for loop
            } //if boss
        }  // if cp
        debug_to_console('server - resultset created');
    }

    /**
     * Implementation of IteratorAggregate
     *
     * @return \ArrayIterator Iterator over results.
     */
    public function getIterator()
    {
        return new \ArrayIterator($this->results);
    }


    /**
     * used to trim results based on max allowed in site setting
     */
    public function set_results($results) {
        $this->results = $results;
    }


    /**
     * @return bings\doc_result[] array of results
     */
    public function get_results() {
        return $this->results;
    }

    public function set_query($query) {
        $this->query = $query;
        return $this;
    }

    /**
     * @return bings\doc_query array of results
     */
    public function get_query() {
        return $this->query;
    }

    public function set_source($source) {
        $this->source = $source;
        return $this;
    }

    /**
     * @return string
     */
    public function get_source() {
        return $this->source;
    }


    // check the domain is in exclude list & also file extension
    public function is_ws_clean($url) {
        global $CFG;
        if (strposa($url, $CFG->ws_domain_excludelist, 1)) {
            return false;
        }
        if(! strposa($url, $CFG->ws_filextensions, 1)) {
            return false;
        }
        return true;
    }

    // check the domain is in exclude list & also file extension
    public function is_cp_clean($url) {
        global $CFG;
        if (strposa($url, $CFG->cp_domain_excludelist, 1)) {
            return false;
        }
        if(! strposa($url, $CFG->cp_filextensions, 1)) {
            return false;
        }
        return true;
    }


    public function jsonSerialize() {
        return [
            'results' => $this->get_results(),
            'query' => $this->get_query(),
            'source' => $this->source // added jan 1st 2019
            ];
    }

}