<?php
namespace bings;
include_once dirname(__DIR__).'/config.php';
/**
 * The Yahoo BOSS Client main class
 *
 * @author Rokkada
 * @copyright Rokkada &copy; 2016
 * @package bings
 * @version 1.0
 */
class search
{
    /**
     * @var string
     */
    private $app_id;
    /**
     * @var bings\file_cache
     */
    private $cache;
    /**
     * @var int
     * 1d-86400, 30d-2592000, 90d-7776000, 180d-15552000
     */
    private $life = 15552000; // seconds

    /**
     * @var string
     * 1d-86400, 30d-2592000, 90d-7776000, 180d-15552000
     */
    //private $source = 'bing5'; // bing or boss // apr 2017 // for bing 5 api // changed to bing5

    private $source = 'bing7'; // bing or boss // jan 2019 // for bing 7 api // changed to bing7

    private $served_from = 'api'; // cache or api - if the data was served from cache or from new api call

    /**
     *
     * @param string $app_id
     * @param bings\file_cache $cache BASC cache, if omitted, no cache will be used
     */
    public function __construct($app_id, file_cache $cache = null, $life = 15552000)
    {
        $this->app_id = $app_id;
        $this->cache = $cache;
        $this->life = $life;
    }

    /**
     * @param Query $query
     * @param bool $useCache
     * @param \DateInterval $cacheLifeTime
     * @return bings\result_set
     */
    public function query(query $query, $site, $check_ttl = false)
    {
        debug_to_console('server - worksheet/cp to find: '.$query->get_keyword()->get_raw_text());

        debug_to_console('server - use cache: '.$site['use_cache']);

        $result = null;

        if (!$site['use_cache']) { // if use cache is false, make api call & return result (no saving cache also)
            $response = $this->call_api($site, $query); // somes api call can return null (when api calls is off). Null check is handled in result_set constructor
            $result = $this->make_result_set($query, $response, $this->source);
            $this->served_from = 'api';
        }
        // if use cache is true, try to retrieve cache from store
        else {
            //debug_to_console('server - use cache: '.$site['use_cache']);

            $cache_data = $this->cache->get($query->get_keyword()->get_cache_name());

            if ($cache_data !== null) {

                debug_to_console('server - cache found');

                // check if the cache is bing7
                // bing if cache has attributes like source, born
                if(isset($cache_data['source']) && $cache_data['source'] === 'bing7') { // added 1st jan 2019 to support bing7

                    debug_to_console('server - cache type - B7');
                    debug_to_console('server - ttl: '.$cache_data['ttl'].' time now:  '. time());

                    //if the cache has expired & check_ttl is true (not crawler)
                    if ($check_ttl && $cache_data['ttl'] < time()) {
                        // cache is stale, delete it
                        debug_to_console('server - cache has stale.');
                        //$this->cache->delete($query->get_keyword()->get_cache_name()); // moved - remove stale cache only if fresh data is available

                        // try to get from api before deleting stale cache
                        $response = $this->call_api($site, $query);

                        // if api does not return proper response

                        $json_response = json_decode($response, true); // may 18th

                        //if(!isset($response)) {
                        if (!isset($json_response)) { // may 18th
                            // serve stale-cache
                            $result = $this->make_result_set($query, $cache_data['data'], $this->source);
                            $this->served_from = 'stale-cache';
                            debug_to_console('server - serving stale cache.');
                        }
                        else { // response is proper
                            $new_result = $this->make_result_set($query, $response, $this->source);

                            // if response contains results
                            if (count($new_result->get_results()) > 0) {
                                $result = $new_result;
                                // delete old cache
                                $this->cache->delete($query->get_keyword()->get_cache_name()); // delete old cache
                                debug_to_console('server - stale cache deleted.');
                                // set new cache
                                $this->cache->set($query->get_keyword()->get_cache_name(), $response, $this->life, $this->source); // create new cache
                                debug_to_console('server - new cache created.');
                                $this->served_from = 'api-refresh';
                                debug_to_console('server - serving from api-refresh.');
                            }
                            else { // response contains zero results
                                debug_to_console('server - api call returned zero results.');
                                $result = $this->make_result_set($query, $cache_data['data'], $this->source);

                                // may 18th 2017 - this is update ttl of existing stale cache so that API is not called for till next ttl expiration
                                // delete old cache
                                $this->cache->delete($query->get_keyword()->get_cache_name()); // delete old cache
                                debug_to_console('server - stale cache deleted.');
                                // set new cache
                                $this->cache->set($query->get_keyword()->get_cache_name(), $cache_data['data'], $this->life, $this->source); // create new cache
                                debug_to_console('server - new cache created from stale cache.');
                                // may 18th - end

                                $this->served_from = 'stale-cache-refresh';
                                debug_to_console('server - serving refreshed stale cache.');
                            }
                        }
                    }
                    else { // else cache has not expired & check_ttl is false (not crawler)
                        // cache is fresh, return it
                        debug_to_console('server - cache is fresh');
                        $this->served_from = 'cache';
                        $result = $this->make_result_set($query, $cache_data['data'], $this->source);
                    }
                }
                // check if the cache is bing5
                // bing if cache has attributes like source, born
                else if(isset($cache_data['source']) && $cache_data['source'] === 'bing5') {

                    debug_to_console('server - cache type - B5');
                    debug_to_console('server - ttl: '.$cache_data['ttl'].' time now:  '. time());

                    //if the cache has expired & check_ttl is true (not crawler)
                    if ($check_ttl && $cache_data['ttl'] < time()) {
                        // cache is stale, delete it
                        debug_to_console('server - cache has stale.');
                        //$this->cache->delete($query->get_keyword()->get_cache_name()); // moved - remove stale cache only if fresh data is available

                        // try to get from api before deleting stale cache
                        $response = $this->call_api($site, $query);

                        // if api does not return proper response

                        $json_response = json_decode($response, true); // may 18th

                        //if(!isset($response)) {
                        if (!isset($json_response)) { // may 18th
                            // serve stale-cache
                            $result = $this->make_result_set($query, $cache_data['data'], $cache_data['source']);
                            $this->served_from = 'stale-cache';
                            debug_to_console('server - serving stale cache.');
                        }
                        else { // response is proper
                            $new_result = $this->make_result_set($query, $response, $this->source);

                            // if response contains results
                            if (count($new_result->get_results()) > 0) {
                                $result = $new_result;
                                // delete old cache
                                $this->cache->delete($query->get_keyword()->get_cache_name()); // delete old cache
                                debug_to_console('server - stale cache deleted.');
                                // set new cache
                                $this->cache->set($query->get_keyword()->get_cache_name(), $response, $this->life, $this->source); // create new cache
                                debug_to_console('server - new cache created.');
                                $this->served_from = 'api-refresh';
                                debug_to_console('server - serving from api-refresh.');
                            }
                            else { // response contains zero results
                                debug_to_console('server - api call returned zero results.');
                                $result = $this->make_result_set($query, $cache_data['data'], $this->source);

                                // may 18th 2017 - this is update ttl of existing stale cache so that API is not called for till next ttl expiration
                                // delete old cache
                                $this->cache->delete($query->get_keyword()->get_cache_name()); // delete old cache
                                debug_to_console('server - stale cache deleted.');
                                // set new cache
                                $this->cache->set($query->get_keyword()->get_cache_name(), $cache_data['data'], $this->life, $this->source); // create new cache
                                debug_to_console('server - new cache created from stale cache.');
                                // may 18th - end

                                $this->served_from = 'stale-cache-refresh';
                                debug_to_console('server - serving refreshed stale cache.');
                            }
                        }
                    }
                    else { // else cache has not expired & check_ttl is false (not crawler)
                        // cache is fresh, return it
                        debug_to_console('server - cache is fresh');
                        $this->served_from = 'cache';
                        $result = $this->make_result_set($query, $cache_data['data'], $cache_data['source']);
                    }
                }
                // check if the cache is from boss or bing (old bing api)
                // bing if cache has attributes like source, born
                else if(isset($cache_data['source']) && $cache_data['source'] === 'bing') {

                    debug_to_console('server - cache type - B');
                    debug_to_console('server - ttl: '.$cache_data['ttl'].' time now:  '. time());

                    //if the cache has expired & check_ttl is true (not crawler)
                    if ($check_ttl && $cache_data['ttl'] < time()) {
                        // cache is stale, delete it
                        debug_to_console('server - cache has stale.');
                        //$this->cache->delete($query->get_keyword()->get_cache_name()); // moved - remove stale cache only if fresh data is available

                        // try to get from api before deleting stale cache
                        $response = $this->call_api($site, $query);

                        // if api does not return proper response
                        if(!isset($response)) {
                            // serve stale-cache
                            $this->source = 'bing';
                            $result = $this->make_result_set($query, $cache_data['data'], $this->source);
                            $this->served_from = 'stale-cache';
                            debug_to_console('server - serving stale cache.');
                        }
                        else { // response is proper
                            $new_result = $this->make_result_set($query, $response, $this->source);

                            // if response contains results
                            if (count($new_result->get_results()) > 0) {
                                $result = $new_result;
                                // delete old cache
                                $this->cache->delete($query->get_keyword()->get_cache_name()); // delete old cache
                                debug_to_console('server - stale cache deleted.');
                                // set new cache
                                $this->cache->set($query->get_keyword()->get_cache_name(), $response, $this->life, $this->source); // create new cache
                                debug_to_console('server - new cache created.');
                                $this->served_from = 'api-refresh';
                                debug_to_console('server - serving from api-refresh.');
                            }
                            else { // response contains zero results
                                $this->source = 'bing';
                                debug_to_console('server - api call returned zero results.');
                                $result = $this->make_result_set($query, $cache_data['data'], $this->source);
                                $this->served_from = 'stale-cache';
                                debug_to_console('server - serving stale cache.');
                            }
                        }
                    }
                    else { // else cache has not expired & check_ttl is false (not crawler)
                        // cache is fresh, return it
                        $this->source = 'bing';
                        debug_to_console('server - cache is fresh');
                        $this->served_from = 'cache';
                        $result = $this->make_result_set($query, $cache_data['data'], $this->source);
                    }
                }
                else { // it is boss cache
                    debug_to_console('server - cache type - Y');
                    $newttl = $cache_data['ttl'] + 7776000;  //add 90 days to ttl to make it good for 180 days
                    debug_to_console('server - ttl: '.$newttl.' time now:  '. time());

                    //if the cache has expired & check_ttl is true (not crawler)
                    if ($newttl < time() && $check_ttl) {
                        debug_to_console('server - cache is stale');

                        // try to get from api before deleting stale cache
                        $response = $this->call_api($site, $query);

                        if(!isset($response)) {
                            $this->source = 'boss';
                            $result = $this->make_result_set($query, $cache_data['data'], $this->source);
                            $this->served_from = 'stale-cache';
                            debug_to_console('server - serving stale cache.');
                        }
                        else {
                            $new_result = $this->make_result_set($query, $response, $this->source);
                            // if api results is not zero
                            if (count($new_result->get_results()) > 0) {
                                $result = $new_result;
                                $this->cache->delete($query->get_keyword()->get_cache_name()); // delete old cache
                                debug_to_console('server - stale cache deleted.');
                                $this->cache->set($query->get_keyword()->get_cache_name(), $response, $this->life, $this->source); // create new cache
                                debug_to_console('server - new cache created.');
                                $this->served_from = 'api-refresh';
                                debug_to_console('server - serving from api-refresh.');
                            } // api results is not zero
                            else { // api results is zero
                                $this->source = 'boss';
                                debug_to_console('server - api call returned zero results.');
                                $result = $this->make_result_set($query, $cache_data['data'], $this->source);
                                $this->served_from = 'stale-cache';
                                debug_to_console('server - serving stale cache.');
                            } // api results is zero
                        } // response is set
                    } // boss cache expired
                    else { // boss not cache expired
                        $this->source = 'boss';
                        debug_to_console('server - cache is fresh');
                        $this->served_from = 'cache';
                        // cache is fresh, return it
                        $result = $this->make_result_set($query, $cache_data['data'], $this->source);

                        // this is only for boss for cleaning up results with no results; this may result in more api calls $$$COST
                        if (count($result->get_results()) < 1) {
                            debug_to_console('server - existing cache has zero results');
                            debug_to_console('server - deleting existing cache');
                            $this->cache->delete($query->get_keyword()->get_cache_name()); // delete old cache
                        }

                    } // boss not cache expired
                } // boss cache
            } // cache is null
            else {
                debug_to_console('server - no cache. making new api call');
                $response = $this->call_api($site, $query);
                $result = $this->make_result_set($query, $response, $this->source);

                if (count($result->get_results()) > 0) {
                    debug_to_console('server - api returned some results');
                    //kunmans - need to cache the response even if api returns no results otherwise bots will keep using api calls [moving this outside if loop
                    //$this->cache->set($query->get_keyword()->get_cache_name(), $response, $this->life, $this->source); // create new cache
                }
                else {
                    debug_to_console('server - api call returned zero results.');
                }
                $this->cache->set($query->get_keyword()->get_cache_name(), $response, $this->life, $this->source); // create new cache
                $this->served_from = 'api';
            }
        }
        return $result;
    }

    // this function for bing old bing api
    private function call_api_old($site, $query) {

        $response = null;
        if($site['api_calls'] === 'on') {
            // Encode the credentials and create the stream context.
            debug_to_console('server - making new api call');

            $data = array(
                'http' => array(
                    'request_fulluri' => true,
                    "Accept-Encoding: gzip\r\n",
                    // ignore_errors can help debug – remove for production. This option added in PHP 5.2.10
                    'ignore_errors' => false,
                    'header' => "Authorization: Basic $auth")
            );

            $context = stream_context_create($data);

            $response = file_get_contents($query->get_search_url(), 0, $context);
        }
        return $response;
    }

    // this modified function for bing api v5
    private function call_api($site, $query) {

        $response = null;
        if($site['api_calls'] === 'on') {
            // Encode the credentials and create the stream context.
            debug_to_console('server - making new api call');
            //$auth = base64_encode("$this->app_id:$this->app_id");

            $data = array(
                'http' => array(
                    'method' => 'GET',
                    //'request_fulluri' => true,
                    //'Accept-Encoding: gzip\r\n',
                    // ignore_errors can help debug – remove for production. This option added in PHP 5.2.10
                    'ignore_errors' => false,
                    'header' => "Ocp-Apim-Subscription-Key:" . $this->app_id . "\r\n"
                )
            );
            debug_to_console($data);
            $context = stream_context_create($data);

            $response = file_get_contents($query->get_search_url(), 0, $context);
            debug_to_console($response);
        }

        $response = preg_replace('/[\x00-\x1F\x80-\xFF]/', '',$response);

        debug_to_console($response);

        return $response;
    }

    private function make_result_set(query $query, $response, $source)
    {
        debug_to_console('server - creating result set');
        $json_response = json_decode($response, true);

        //$json_response = json_decode(preg_replace('/[\x00-\x1F\x80-\xFF]/', '',$response), true);

        switch (json_last_error()) {
            case JSON_ERROR_NONE:
                debug_to_console(' - No errors');
                break;
            case JSON_ERROR_DEPTH:
                debug_to_console( ' - Maximum stack depth exceeded');
                break;
            case JSON_ERROR_STATE_MISMATCH:
                debug_to_console( ' - Underflow or the modes mismatch');
                break;
            case JSON_ERROR_CTRL_CHAR:
                debug_to_console( ' - Unexpected control character found');
                break;
            case JSON_ERROR_SYNTAX:
                debug_to_console( ' - Syntax error, malformed JSON');
                break;
            case JSON_ERROR_UTF8:
                debug_to_console( ' - Malformed UTF-8 characters, possibly incorrectly encoded');
                break;
            default:
                debug_to_console( ' - Unknown error');
                break;
        }

        debug_to_console($json_response);
        return new result_set($query, $json_response, $source);
    }

    public function served_from() {
        return $this->served_from;
    }

    public function get_source() {
        return $this->source;
    }
}