<?php



namespace GeoIp2;

include_once 'config.php';

if (version_compare(PHP_VERSION, '5.3', '<')) {
    throw new \Exception('The bings package needs PHP 5.3.0 or higher.');
}
if (!ini_get('allow_url_fopen')) {
    throw new \Exception('The bings package relies on the allow_url_fopen setting. Please turn it on in php.ini or with ini_set(\'allow_url_fopen\', \'1\');');
}

/**
 * Autoload function
 */
function autoload($className) {
    $filename = dirname(__FILE__) . '/' . str_replace('\\', '/', $className) . '.php';
    //debug_to_console("file name: ". $filename);
    if (file_exists($filename)) {
        require_once $filename;
        return true;
    }
    return false;
}

spl_autoload_register('GeoIp2\\autoload');