<?php
    // this service is to return geo info (country) for a given ip address
    // this uses 2 external libraries - MaxMind & GeoIp2
    // it also used GeoLite country database provided by MaxMinds (GeoLiteDB/GeoLite2-Country.mmdb)
    // Turn off all error reporting
    error_reporting(0); // this is important otherwise file io warning is also sent in response to client

    include_once '/config.php';

    global $CFG;

    // main server library
    require 'bings.lib.php';

    // third party library to detect bots/crawlers
    require 'geoip2.lib.php';

    // this is third party library to get country info from ip
    use GeoIp2\Database\Reader;

    debug_to_console('server - inside geoip service');

    $ip = $_POST['ip'];

    debug_to_console('server - geoip: '.$ip);

    // This creates the Reader object, which should be reused across
    // lookups.
    $reader = new Reader($CFG->geolite_country_db_path);

    // "country".
    $record = $reader->country($ip);

    $data = array('data' => array(
            'ip' => $ip,
            'country_iso' =>  $record->country->isoCode,
            'country_name' =>  $record->country->name
            ));

    debug_to_console('server - geoip info being sent as below ');
    debug_to_console($data);

    debug_to_console('server - sending back geoip info');
    echo json_encode($data);


    // utf conversion method - not used currently
    function utf8ize($d) {
        if (is_array($d)) {
            foreach ($d as $k => $v) {
                $d[$k] = utf8ize($v);
            }
        } else if (is_string ($d)) {
            return utf8_encode($d);
        }
        return $d;
    }