<?php

    include_once 'config.php';

    global $CFG;

    require 'bings.lib.php';
    require 'maxmind.lib.php';
    require 'jaybizzle.lib.php';

    debug_to_console('server - inside keyword service');

    $q = trim($_POST['kw']);
    $headers = $_POST['headers'];

    /*
     * to support lk cp  29th Mar 2018
     * instead of using header http host, using posted "site" param value to accomodate cp also on lk site
     */
    //$sitename = $headers['HTTP_HOST'];
    $sitename = trim($_POST['site']); // lk testing

    $sitename = str_ireplace('www.', '', $sitename);

    $site = $CFG->sites[$sitename];

    $stype = $site['search_type'];

    $agent = null; //user or bot
    $status = null; //OK, INVAL, UNAUTH

    debug_to_console($headers);
    debug_to_console('server - keyword: '.$q);
    debug_to_console('server - stype: '.$stype);
    debug_to_console('server - sitename: '.$sitename);
    debug_to_console($site);


    $data = array('data' => '');
    $keyword = null;
    if (isset($site) && $site['requests'] === 'on' && $q != '' &&  \bings\util::is_user_agent_valid($headers['HTTP_USER_AGENT'])) {
        $keyword = new bings\keyword($q, $stype);
        debug_to_console('server - keyword object: ' . json_encode($keyword));
        $result_set = array('query' => array('keyword' => $keyword));
        $data = array('data' => $result_set);

        // if invalid keyword log it; if valid, don't log because it will get logged when search request is made
        if ($keyword->is_valid() === false) {
            // invalid keyword - send only keyword object
            debug_to_console('server - invalid keyword');
            $status = 'INVAL';
            $result_set = array('query' => array('keyword' => $keyword));

            // logging request to database
            $logdata = Array (
                "keyword" => isset($keyword) ? $keyword->get_clean_text() : '',
                "type" => $stype,
                "site" => $sitename,
                "agent" => $agent,
                "served_from" => isset($search) ? $search->served_from() : '',
                "cache_name" => isset($keyword) ? $keyword->get_cache_name(): '',
                "user_ip" => $headers['REMOTE_ADDR'],
                'timestamp' => $headers['REQUEST_TIME_FLOAT'],
                'status' => $status,
                'keyword_json' => json_encode($keyword),
                'header_json' => json_encode($headers)
            );

            // log request based on stype, status
            bings\util::log_request($logdata, $stype, $status);

        }
        debug_to_console('server - valid request: sending back keyword service response');
        echo json_encode($data);
    }
    else {
        // unauthorised - send empty result
        debug_to_console('server - unauthorised request');
        $status = 'UNAUTH';
        $data = array('data' => '');

        // logging request to database
        $logdata = Array (
            "keyword" => isset($keyword) ? $keyword->get_clean_text() : $q,
            "type" => $stype,
            "site" => $sitename,
            "agent" => $agent,
            "served_from" => isset($search) ? $search->served_from() : '',
            "cache_name" => isset($keyword) ? $keyword->get_cache_name(): '',
            "user_ip" => $headers['REMOTE_ADDR'],
            'timestamp' => $headers['REQUEST_TIME_FLOAT'],
            'status' => $status,
            'keyword_json' => json_encode($keyword),
            'header_json' => json_encode($headers)
        );

        // log request based on stype, status
        bings\util::log_request($logdata, $stype, $status);
        debug_to_console('server - unauthorised request; sending empty data in keyword service response');
        echo json_encode($data);
    }


