<?php

    // Turn off all error reporting
    error_reporting(0); // this is important otherwise file io warning is also sent in response to client

    include_once '/config.php';

    global $CFG;

    // main server library
    require 'bings.lib.php';

    // third party library to detect bots/crawlers
    require 'jaybizzle.lib.php';

    // this is third party library used to detect crawlers
    use Jaybizzle\CrawlerDetect\CrawlerDetect;

    debug_to_console('server - inside search service');


    $q = trim($_POST['kw']);
    $headers = $_POST['headers'];

    /*
     * to support lk cp  29th Mar 2018
     * instead of using header http host, using posted "site" param value to accomodate cp also on lk site
     */
    //$sitename = $headers['HTTP_HOST'];
    $sitename = trim($_POST['site']); // lk testing

    $sitename = str_ireplace('www.', '', $sitename);

    $site = $CFG->sites[$sitename];
    debug_to_console($site);

    $stype = $site['search_type'];

    $agent = null; //user or bot
    $status = null; //OK, INVAL, UNAUTH

    debug_to_console($headers);
    debug_to_console('server - keyword: '.$q);
    debug_to_console('server - stype: '.$stype);
    debug_to_console('server - sitename: '.$sitename);
    //debug_to_console($site); // CAREFUL - this contains app id information


    $data = array('data' => '');
    $keyword = null;

    if (isset($site) && $site['requests'] === 'on' && $q != '' && \bings\util::is_user_agent_valid($headers['HTTP_USER_AGENT'])) {

        $search = null;
        if ($stype === 'ws') {
            $cache = new bings\file_cache($site['cache_store'] === '' ? $CFG->ws_cache_store : $site['cache_store']);
            $search = new bings\search($site['app_id']  === '' ? $CFG->bing_ws_app_id : $site['app_id'], $cache, $CFG->ws_cache_life);
        } elseif ($stype === 'cp') {
            $cache = new bings\file_cache($site['cache_store'] === '' ? $CFG->cp_cache_store : $site['cache_store']);
            $search = new bings\search($site['app_id']  === '' ? $CFG->bing_cp_app_id : $site['app_id'], $cache, $CFG->cp_cache_life);
        }

        $keyword = new bings\keyword($q, $stype);
        debug_to_console('server - keyword object: '.json_encode($keyword));

        $check_ttl = false;
        $result_set = null;

        if ($keyword->is_valid() === true) {

            // check if it user or bot making request
            $crawler_detect = new CrawlerDetect();

            //debug_to_console($crawler_detect->userAgent);
            debug_to_console('server - checking if it is crawler/bot');

            debug_to_console('server - user_agent: '.$headers['HTTP_USER_AGENT']);

            // Check the user agent of the current 'visitor; if crawler, no need to check if cache is expired (check_ttl = false)
            if($crawler_detect->isCrawler($headers['HTTP_USER_AGENT'])) { // if bot, API call is not done irrespective of if cache expired or not. Whatever the available cache is used

                debug_to_console('server - crawler: true');
                $check_ttl = false;
                $agent = 'bot';

            } else { //if not bot, use the site level cache settting
                debug_to_console('server - crawler: false');
                //$check_ttl = true;
                $check_ttl = $site['check_ttl'];
                $agent = 'user';
            }

            $query = null;

            if ($stype === 'ws'){
                $query = new bings\doc_query($keyword);
            } else {
                $query = new bings\img_query($keyword);
            }

            // query, use_cache, ttl_check
            $result_set = $search->query($query, $site, $check_ttl);

            debug_to_console('server - source: ' . $result_set->get_source());
            debug_to_console('server - served from: ' . $search->served_from());
            $status = 'OK';

        } else {
            // invalid keyword - send only keyword object
            debug_to_console('server - invalid keyword');
            $status = 'INVAL';
            $result_set = array('query' => array('keyword' => $keyword));
        }
        debug_to_console('server - total results : ' . count($result_set->get_results()));
        debug_to_console('server - max results allowed: ' . $site['max_results']);

        // trim results to site max
        if(count($result_set->get_results()) > $site['max_results']) {
            debug_to_console('server - trimming results ');
            $results = $result_set->get_results();
            $trimmed_results = array_slice($results, 0, $site['max_results']);
            $result_set->set_results($trimmed_results);
        }
        $data = array('data' => $result_set);

    } else {
        // unauthorised - send empty result
        debug_to_console('server - unauthorised request');
        $status = 'UNAUTH';
        $data = array('data' => '');
    }

    // logging request to database
    $logdata = Array (
        "keyword" => isset($keyword) ? $keyword->get_clean_text() : '',
        "type" => $stype,
        "site" => $sitename,
        "agent" => $agent,
        "served_from" => isset($search) ? $search->served_from() : '',
        "cache_name" => isset($keyword) ? $keyword->get_cache_name(): '',
        "user_ip" => $headers['REMOTE_ADDR'],
        'timestamp' => $headers['REQUEST_TIME_FLOAT'],
        'status' => $status,
        'keyword_json' => json_encode($keyword),
        'header_json' => json_encode($headers)
    );

    // log request based on stype, status
    bings\util::log_request($logdata, $stype, $status);

    debug_to_console('server - results being sent as below ');
    debug_to_console($data);

    debug_to_console('server - sending back response');
    echo json_encode($data);


    // utf conversion method - not used currently
    function utf8ize($d) {
        if (is_array($d)) {
            foreach ($d as $k => $v) {
                $d[$k] = utf8ize($v);
            }
        } else if (is_string ($d)) {
            return utf8_encode($d);
        }
        return $d;
    }